use bd_vendas
GO

---------------------
-- CRIACAO TABELAS --
---------------------

create table venda (
	num_venda	int not null,
	cod_funcionario tinyint NOT NULL ,
	dtc_venda	smalldatetime not null,
	cod_forma_pgto	tinyint not null
)
GO

create table forma_pgto (
	cod_forma_pgto	tinyint not null,
	des_forma_pgto varchar(20),
	dtc_atualizacao smalldatetime
)
GO	

alter table forma_pgto add constraint ix_forma_pgto01 primary key nonclustered (cod_forma_pgto)
GO

create table funcionario (
	cod_funcionario tinyint not null ,
	nom_funcionario varchar (50) not null ,
	dtc_admissao smalldatetime not null ,
	dtc_atualizacao smalldatetime not null 
) 
GO

alter table funcionario add constraint ix_funcionario01 primary key nonclustered (cod_funcionario)
GO

alter table venda add constraint fk_venda_funcionario01 foreign key (cod_funcionario)
references funcionario(cod_funcionario)
GO

alter table venda add constraint fk_venda_forma_pgto01 foreign key (cod_forma_pgto)
references forma_pgto(cod_forma_pgto)
GO

---------------------
-- CARGA DOS DADOS --
---------------------

-- Tabela funcionario
insert into funcionario (cod_funcionario,nom_funcionario,dtc_admissao,dtc_atualizacao) 
values (1,'Marcos','1995.01.05',getdate())

insert into funcionario (cod_funcionario,nom_funcionario,dtc_admissao,dtc_atualizacao) 
values (2,'Ana','1995.01.05',getdate())

insert into funcionario (cod_funcionario,nom_funcionario,dtc_admissao,dtc_atualizacao) 
values (3,'Paulo','1995.01.08',getdate())

insert into funcionario (cod_funcionario,nom_funcionario,dtc_admissao,dtc_atualizacao) 
values (4,'Marta','1995.01.08',getdate())

insert into funcionario (cod_funcionario,nom_funcionario,dtc_admissao,dtc_atualizacao) 
values (5,'Erica','1995.01.12',getdate())

insert into funcionario (cod_funcionario,nom_funcionario,dtc_admissao,dtc_atualizacao) 
values (6,'Marcelo','1995.01.12',getdate())

insert into funcionario (cod_funcionario,nom_funcionario,dtc_admissao,dtc_atualizacao) 
values (7,'Fabricio','1995.01.12',getdate())

insert into funcionario (cod_funcionario,nom_funcionario,dtc_admissao,dtc_atualizacao) 
values (8,'Adriana','1995.01.12',getdate())

insert into funcionario (cod_funcionario,nom_funcionario,dtc_admissao,dtc_atualizacao) 
values (9,'Eduardo','1995.01.12',getdate())


-- Tabela forma_pgto
insert into forma_pgto (cod_forma_pgto, des_forma_pgto, dtc_atualizacao)
values (1,'a vista',getdate())

insert into forma_pgto (cod_forma_pgto, des_forma_pgto, dtc_atualizacao)
values (2,'cartao credito',getdate())

insert into forma_pgto (cod_forma_pgto, des_forma_pgto, dtc_atualizacao)
values (3,'cartao debito',getdate())

insert into forma_pgto (cod_forma_pgto, des_forma_pgto, dtc_atualizacao)
values (4,'cheque',getdate())

